<?php

namespace YOOtheme\Theme\Wordpress\Listener;

class FilterPostStates
{
    public static function handle($post_states, \WP_Post $post = null)
    {
        // is builder?
        if ($post && ($post->builder = preg_match('/<!--\s?{/', $post->post_content))) {
            $post_states = (array) $post_states;

            // remove gutenberg?
            $key = array_search('Gutenberg', $post_states);

            if ($key !== false) {
                unset($post_states[$key]);
            }

            $post_states['yootheme'] = __('YOOtheme', 'yootheme');
        }

        return $post_states;
    }
}
