<?php

namespace YOOtheme\Theme\Wordpress\Listener;

use YOOtheme\Config;
use YOOtheme\Path;
use YOOtheme\Url;

class AddAdminMenuButton
{
    public Config $config;

    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    /**
     * Fires before the administration menu loads in the admin.
     *
     * @link https://developer.wordpress.org/reference/hooks/admin_menu/
     */
    public function handle()
    {
        add_menu_page(
            '',
            __('YOOtheme', 'yootheme'),
            'edit_theme_options',
            Path::relative(get_admin_url(), wp_customize_url(wp_get_theme()->get_stylesheet())),
            '',
            '',
            60
        );

        wp_enqueue_style(
            'yootheme-link-style',
            Url::to(
                Path::get('../../assets/css/icon.css'),
                ['ver' => $this->config->get('theme.version')],
                is_ssl()
            )
        );
    }
}
