<?php

namespace YOOtheme\Theme\Wordpress\Listener;

use YOOtheme\Config;

class LoadCustomScript
{
    public Config $config;

    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    /**
     * Prints scripts or data in the head tag on the front end.
     *
     * @link https://developer.wordpress.org/reference/hooks/wp_head/
     */
    public function handle(): void
    {
        if ($script = $this->config->get('~theme.custom_js', '')) {
            if (stripos(trim($script), '<script') !== 0) {
                $script = "<script>{$script}</script>";
            }

            echo $script;
        }
    }
}
